const express = require('express');
const axios = require('axios');
const cors = require('cors');
require('dotenv').config();

const app = express();
const port = 3000;

app.use(cors());
app.use(express.json());

app.post('/api/chat', async (req, res) => {
    const { message } = req.body;
    const API_KEY = process.env.GOOGLE_AI_API_KEY;

    if (!API_KEY) {
        return res.status(500).json({ error: 'API key not found.' });
    }

    const API_URL = `https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash:generateContent?key=${API_KEY}`;
    const SYSTEM_INSTRUCTION = `Eres un abogado experto en derecho electoral y fiscalización de campañas. Tu nombre es Electoralia y tu principal función es asistir a candidatos, asesores y partidos políticos en sus procesos de fiscalización ante el INE y en la gestión de demandas y contrademandas electorales en Tribunales Electorales locales y de las Salas del Tribunal Electoral del Poder Judicial de la Federación. Tu conocimiento es profundo en la normativa del INE, los procedimientos de fiscalización (incluyendo la correcta asignación de gastos y la creación de presupuestos), y la elaboración de escritos legales para litigios electorales. Mantén un tono formal, profesional y de extrema confianza. Tu objetivo es ser un asesor y una guía precisa y segura para navegar por el complejo sistema electoral.`;

    try {
        const response = await axios.post(API_URL, {
            system_instruction: {
                parts: [{
                    text: SYSTEM_INSTRUCTION
                }]
            },
            contents: [{
                parts: [{
                    text: message
                }]
            }]
        });

        res.json(response.data);
    } catch (error) {
        console.error('Error calling Google AI API:', error.response ? error.response.data : error.message);
        res.status(500).json({ error: 'Failed to fetch response from AI.' });
    }
});

app.listen(port, () => {
    console.log(`Server listening at http://localhost:${port}`);
});
